***********************************************************************
*
* teach uevent.aii -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the teach program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.window
               copy teach.equ

               mcopy macros/uevent.macros

               longi on
               longa on

***********************************************************************

enableDAItems  start

               pea UndoItem
               _EnableMItem
               pea CloseItem
               _EnableMItem
               pea $FF7F
               pea EditMenuID
               _SetMenuFlag
               rts

               end

***********************************************************************

enableAppItems start

               pea SelectAllItem
               _EnableMItem
               pea CloseItem
               _EnableMItem
               pea SaveItem
               _EnableMItem
               pea SaveAsItem
               _EnableMItem
               pea PageSetupItem
               _EnableMItem
               pea PrintItem
               _EnableMItem
               pea $FF7F
               pea SizeMenuID
               _SetMenuFlag
               pea $FF7F
               pea StyleMenuID
               _SetMenuFlag
               pea $FF7F
               pea FontMenuID
               _SetMenuFlag
               pea $FF7F
               pea EditMenuID
               _SetMenuFlag
               rts

               end

***********************************************************************

disableDAItems start

               pea UndoItem
               _DisableMItem
               rts

               end

***********************************************************************

disableAppItems start

               pea $0080
               pea EditMenuID
               _SetMenuFlag
               pea $0080
               pea FontMenuID
               _SetMenuFlag
               pea $0080
               pea StyleMenuID
               _SetMenuFlag
               pea $0080
               pea SizeMenuID
               _SetMenuFlag
               pea SaveItem
               _DisableMItem
               pea SaveAsItem
               _DisableMItem
               pea PageSetupItem
               _DisableMItem
               pea PrintItem
               _DisableMItem
               pea SelectAllItem
               _DisableMItem
               rts

               end

***********************************************************************
*
* CheckFrontW
*
* This routine checks the front window to see if any changes need
* to be made to the menu items.
*
* We do this so that the edit items are only active when a desk
* accessory is active.
*
checkFrontW    start

               DefineStack

wptr           long                     ;Must be at 1,s.

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for wptr.
               pha
               tsc
               tcd                      ;Set directPage register.

               _FrontWindow             ;wptr is the result space.

               lda wptr                 ;Same top window?
               ldx wptr+2
               cmp lastWindow
               bne newTop
               cpx lastWindow+2
               beq exit

newTop         sta lastWindow
               stx lastWindow+2
               ora wptr+2
               bne thereIsATop

               jsr disableDAItems
               jsr disableAppItems
               pea CloseItem
               _DisableMItem
               brl drawMenuBar

thereIsATop    pha
               pei wptr+2
               pei wptr
               _GetSysWFlag
               pla
               beq ourWindow
               jsr disableAppItems
               jsr enableDAItems
               brl drawMenuBar

ourWindow      jsr disableDAItems
               jsr enableAppItems

drawMenuBar    _DrawMenuBar

exit           pla                      ;Remove local space.
               pla
               pld                      ;Restore directPage register.
               rts

               end

***********************************************************************
*
* mainEvent
*
* This is the main part of the program.  The program cycles in this
* loop until the user choose select.
*
mainEvent      start

loopLongAndHard jsr checkFrontW

               pha
               pea $FFFF
               PushLong #event
               _TaskMaster
               pla
               cmp #wInGoAway
               bne aa
               jsr doCloseTop
               brl next

aa             cmp #wInSpecial
               beq ab
               cmp #wInMenuBar
               bne next
ab             jsr doMenu

next           lda quitFlag
               beq loopLongAndHard

               rts

               end
